#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#'# Setup filenames

filename <- "SAP2016 Secundaria RAW3 NOPII_relabelled" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#'# Setup data, functions and create dictionary for dataset review
source (functions_vers)

#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 


#'# Direct PII: variables to be removed

# !!!Include any Direct PII variables
dropvars <- c("a_nom",
              "c_nom",
              "a_apepat",
              "c_apepat",
              "a_apemat",
              "c_apemat",
              "j_dni",
              "l_dni") 
mydata <- mydata[!names(mydata) %in% dropvars]

#'# Direct PII-team: Encode field team names
# !!!Replace vector in "variables" field below with relevant variable names

mydata <- encode_direct_PII_team (variables=c("dig", "encues"))

#'# Small locations: Encode locations  with pop <100,000 using random large numbers

# !!! Removed as it contains identifying information
dropvars <- c("nomesc") 
mydata <- mydata[!names(mydata) %in% dropvars]

# !!!Include relevant variables, but check their population size first to confirm they are <100,000
locvars <- c("codloc", "codmod") 
mydata <- encode_location (variables= locvars, missing=999999)

#'# Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 

dropvars <- c("d_dd",
              "d_mm",
              "f_dd",
              "f_mm") 
mydata <- mydata[!names(mydata) %in% dropvars]

#'# Indirect PII - Categrical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("nivesc",
                  "g_sexo",
                  "i_sexo",
                  "q42_1",
                  "q42_2",
                  "q42_3",
                  "q42_4",
                  "q43")

capture_tables (indirect_PII)

# Recode those with very specific values. 
# !!! No very specific values

#'# Matching and crosstabulations: Run automated PII check 

# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('grado', 'd_aa', 'g_sexo') ##!!! Replace with candidate categorical demo vars


# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial

#' Show values of key variable of records that violate k-anonymity
mydata <- labelDataset(mydata)
notAnon <- sdcInitial@risk$individual[,2] < 2 # for 2-anonymity
mydata[notAnon,selectedKeyVars]
sdcFinal <- localSuppression(sdcInitial)

# Recombining anonymized variables

extractManipData(sdcFinal)[notAnon,selectedKeyVars] # manipulated variables HH
mydata[notAnon,"g_sexo"]<- NA
mydata [notAnon,"grado"] <- NA
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial

#'# Open-ends: review responses for any sensitive information, redact as necessary

# !!! Identify open-end variables here: 
open_ends <- c("q11_b",
               "q12_b",
               "q17_b",
               "q18_b",
               "q23b",
               "q23d")

report_open (list_open_ends = open_ends)

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 
# !!! Remove, as they contain a lot of sensitive information and they are in Spanish.
mydata <- mydata[!names(mydata) %in% open_ends]

#'# GPS data: Displace
# !!! No GPS data

#'# Save processed data in Stata and SPSS format

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
